## README file

Dear students,

We extend a warm welcome to you as you embark on the exciting journey of writing your thesis. We understand that this may seem daunting, but rest assured, we are here to support you every step of the way.

To help you get started, we have created a Latex template specifically for the Institute of Water and River Basin Management department, which you will find detailed instructions for in this guide. This template will not only make your writing process easier and more efficient but will also ensure that your thesis meets the necessary formatting requirements.

We encourage you to personalize your thesis by choosing a topic that aligns with your personal interests and passions. This will not only make the writing process more enjoyable, but also result in a more compelling and well-written thesis.

We wish you the best of luck in your thesis writing endeavors and look forward to seeing the great work you will produce using this Latex template.

Best regards,
The team of the Institute of Water and River Basin Management


## Master's Thesis Template
This template contains .tex files for writing a thesis in the usual format of the Institute of Water and River Basin Management (KIT).

### Attention!
- By using this template one is not exempted of checking for mistakes or adapting for other preferences. 
- The creater of this template does not hold legal responsability for its implementation. However, improvements and constructive feedback is more than welcomed; mail to ricardo.barros@kit.com.

### IWG template structure
This template is composed by the following folders and files. 

- In **_helpful_info** folder, you will find instructions on using the IWG template. Also, you a find a catalog with useful phrase structures for each section of your thesis.

 - In the folder **_thesis_guidelines**, you will find: 
1. Leitfaden für Studien- und Abschlussarbeiten am IWG-SWW: Guidelines in german for choosing study project and thesis topics for students.
2. Statutes for Safeguarding Good Research Practice at KIT
3. How to write a report: a short guide containing general remarks on the thesis sections' content.

- In the folder **Images**, you will find the KIT and IWG logos printed on the title page of this template. Organizing your images in folders is good practice to avoid polluting the browser. 

In the folder **Sections**, you will find the compartmentalized sections of your thesis. You should write the content of your thesis inside its separate .tex file. The appendix is the only file type you should occasionally create or delete if you have more than one appendix or none, respectively. 

The **bibliography.bib** file contains the citation structure of bibiteX. If you use google scholar, for example, you can find this bibiteX structure of your desired paper/book/etc. under CITE>>>bibiteX. Copy and paste the structure inside Bibliography.bib, and you are ready to cite your chosen paper/book/etc. within teh body of your thesis. 

The **main.tex** file contains the Latex commands that put the entire structure of the thesis together. Main.tex also calls the necessary packages to run the template. You will probably find additional packages that will be useful in your thesis that should be called here. In addition, you may want to remove one optional section (e.g., acknowledgments) or add a new appendix. You will be able to make all those changes within main.tex. If you are a beginner at Latex, at first glance, the code seems messy. However, don't get scared; after a little time looking at it and googling for other examples, you will understand the logic. [Overleaf](overleaf.com) has many comprehensive guides for using Latex. 

### Useful links for writing your thesis

- [Here] (https://www.hoc.kit.edu/5489.php) We recommend reading literature for the preparation of theses and / or attending of HOC courses accompanying the writing process (e.g. writing laboratory at the HoC).

- [Here](https://www.phrasebank.manchester.ac.uk/) you find tips from the University of Manchester on how to write and structure the research you've done during your thesis
- 
- The so-called [Turabian](https://www.chicagomanualofstyle.org/turabian.html) offers not only specifics on writing a Thesis, such as punctuation and citation, but also an insightful view on the pilars of research. Here you find how to state of research question, elaborate hypothesis and their testing, defining your claim and engaging with your reader in the discussions. In addition, they offer [tip sheets](https://www.chicagomanualofstyle.org/turabian/Student-Tip-Sheets.html) for several elements of your academic writing, such as how to organize your figures and tables.



